/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4-BIT ARITHMETIC LOGIC UNIT 
TRUTHTABLE     : 
                      COMPARATOR FUNCTION
               -----------------------------------
                 CN   CN_PLUS_4  ACTIVE LOW DATA
               -----------------------------------
                                      _
                 H       H          A > B 
           
                 H       L          A < B

                 L       H          A > B
                                      _
                 L       L          A < B   
               -----------------------------------

                 FUNCTION :TABLE FOR INPUT BITS EQUAL/NOT EQUAL
                        S0 = S3 = H, S1 = S2 = L, M = H
           ---------------------------------------------------------- 
            CN              DATA INPUTS              G_  P_  CNPLUS4
           ---------------------------------------------------------- 
            H    A0_=B0_ A1_=B1_ A2_=B2_ A3_=B3_     H   L     H

            L    A0_=B0_ A1_=B1_ A2_=B2_ A3_=B3_     H   L     L

            X    A0_!=B0_   X       X       X        H   H     L

            X       X    A1_!=B1_   X       X        H   H     L

            X       X       X    A2_!=B2_   X        H   H     L

            X       X       X       X    A3_!=B3_    H   H     L
           ---------------------------------------------------------- 
               
                 FUNCTION TABLE FOR INPUT PAIRS HIGH/NOT HIGH
                       S0 = S1 = S3 = L, S2 = H, M = H
           ---------------------------------------------------------- 
            CN              DATA INPUTS              G_  P_  CNPLUS4
           ---------------------------------------------------------- 
            H    A0_ OR B0_ = L .. A3_ OR B3_ = L    H   L     H

            L    A0_ OR B0_ = L .. A3_ OR B3_ = L    H   L     L

            X    A0_=B0_ = H   X       X       X     H   H     L

            X       X    A1_=B1_ = H   X       X     H   H     L

            X       X       X    A2_=B2_ = H   X     H   H     L

            X       X       X       X    A3_=B3_ = H H   H     L
           ---------------------------------------------------------- 
               
                              FUNCTION TABLE
  ---------------------------------------------------------------------------------
      SELECTION                       ACTIVE LOW DATA
  ---------------------------------------------------------------------------------
                     M = H LOGIC     (M = L) ARITHMATIC OPERATIONS
    S3 S2 S1 S0       FUNCTIONS      CN = L                CN = H
                                   (no carry)            (with carry)
  ---------------------------------------------------------------------------------
                          _        
    L  L  L  L        F = A        F = A MINUS 1         F = A
                          __        
    L  L  L  H        F = AB       F = AB MINUS 1        F = AB
                          _             _                     _
    L  L  H  L        F = A+B      F = AB MINUS 1        F = AB
                                 
    L  L  H  H        F = 1        F = MINUS 1           F = ZERO
                          ___                    _                     _
    L  H  L  L        F = A+B      F = A PLUS (A+B)      F = A PLUS (A+B) PLUS 1
                          _                       _                     _
    L  H  L  H        F = B        F = AB PLUS (A+B)     F = AB PLUS (A+B) PLUS 1
                          ___                                  
    L  H  H  L        F = A^B      F = A MINUS B MINUS 1 F = A MINUS B
                            _            _                      _
    L  H  H  H        F = A+B      F = A+B               F = (A+B) PLUS 1
                          _
    H  L  L  L        F = AB       F = A PLUS (A+B)      F = A PLUS (A+B) PLUS 1

    H  L  L  H        F = A^B      F = A PLUS B          F = A PLUS B PLUS 1
                                        _                     _
    H  L  H  L        F = B        F = AB PLUS (A+B)     F = AB PLUS (A+B) PLUS 1

    H  L  H  H        F = A+B      F = (A+B) PLUS 1      F = (A+B) PLUS 1

    H  H  L  L        F = 0        F = A PLUS A          F = A PLUS A PLUS 1
                           _       
    H  H  L  H        F = AB       F = AB PLUS A         F = AB PLUS A PLUS 1
                                        _                     _
    H  H  H  L        F = AB       F = AB PLUS A         F = AB PLUS A PLUS 1

    H  H  H  H        F = A        F = A                 F = A PLUS 1
  ---------------------------------------------------------------------------------
                        
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a181 (b0n, a0n, s3, s2, s1, s0, cn, m, f0n, f1n, f2n, f3n, aeqb, pn, cn4, gn, b3n, a3n, b2n, a2n, b1n, a1n);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		s0,
		s1,
		s2,
		s3,
		m,
		cn,
		a0n,
		b0n,
		a1n,
		b1n,
		a2n,
		b2n,
		a3n,
		b3n;
	output
		pn,
		gn,
		cn4,
		aeqb,
		f0n,
		f1n,
		f2n,
		f3n;
    not
	  (m181_inst_b3, b3n);
    not
	  (m181_inst_b2, b2n);
    not
	  (m181_inst_b1, b1n);
    not
	  (m181_inst_b0, b0n);
    not
	  (m181_inst_m_, m);
    and
	  (m181_inst_wa1, m181_inst_wnor3_2);
    and
	  (m181_inst_wa2, m181_inst_wnor3_1, m181_inst_wnor2_2);
    and
	  (m181_inst_wa3, m181_inst_wnor3_1, m181_inst_wnor2_1, m181_inst_wnor1_2);
    and
	  (m181_inst_wa4, m181_inst_wnor3_1, m181_inst_wnor2_1, m181_inst_wnor1_1, m181_inst_wnor0_2);
    and
	  (m181_inst_wa5, cn, m181_inst_wnor0_1, m181_inst_wnor1_1, m181_inst_wnor2_1, m181_inst_m_);
    and
	  (m181_inst_wa6, m181_inst_wnor1_1, m181_inst_wnor2_1, m181_inst_wnor0_2, m181_inst_m_);
    and
	  (m181_inst_wa7, m181_inst_m_, m181_inst_wnor2_1, m181_inst_wnor1_2);
    and
	  (m181_inst_wa8, m181_inst_m_, m181_inst_wnor2_2);
    and
	  (m181_inst_wa9, cn, m181_inst_wnor0_1, m181_inst_wnor1_1, m181_inst_m_);
    and
	  (m181_inst_wa10, m181_inst_wnor1_1, m181_inst_wnor0_2, m181_inst_m_);
    and
	  (m181_inst_wa11, m181_inst_wnor1_2, m181_inst_m_);
    and  
	  (aeqb, m181_inst_f3_int, m181_inst_f2_int, m181_inst_f1_int, m181_inst_f0_int);
    nor
	  (m181_inst_g_int, m181_inst_wa1, m181_inst_wa2, m181_inst_wa3, m181_inst_wa4);
    nor
	  (m181_inst_wnor2, m181_inst_wa5, m181_inst_wa6, m181_inst_wa7, m181_inst_wa8);
    nor
	  (m181_inst_wnor3, m181_inst_wa9, m181_inst_wa10, m181_inst_wa11);
    xor
	  (m181_inst_wex1, m181_inst_wnor3_1, m181_inst_wnor3_2);
    xor
	  (m181_inst_wex2, m181_inst_wnor2_1, m181_inst_wnor2_2);
    xor
	  (m181_inst_wex3, m181_inst_wnor1_1, m181_inst_wnor1_2);
    xor
	  (m181_inst_wex4, m181_inst_wnor0_1, m181_inst_wnor0_2);
    xor
	  (m181_inst_f3_int, m181_inst_wex1, m181_inst_wnor2);
    xor
	  (m181_inst_f2_int, m181_inst_wex2, m181_inst_wnor3);
    xor
	  (m181_inst_f1_int, m181_inst_wex3, m181_inst_wnor4);
    xor
	  (m181_inst_f0_int, m181_inst_wex4, m181_inst_wna3);
    buf  
	  (gn, m181_inst_g_int);
    buf  
	  (f3n, m181_inst_f3_int);
    buf  
	  (f2n, m181_inst_f2_int);
    buf  
	  (f1n, m181_inst_f1_int);
    buf  
	  (f0n, m181_inst_f0_int);
    nand
	  (m181_inst_wna1, m181_inst_wnor3_1, m181_inst_wnor2_1, m181_inst_wnor1_1, m181_inst_wnor0_1, cn);
    nand  
	  (pn, m181_inst_wnor3_1, m181_inst_wnor2_1, m181_inst_wnor1_1, m181_inst_wnor0_1);
    nand
	  (m181_inst_wna3, m181_inst_m_, cn);
    nand  
	  (cn4, m181_inst_g_int, m181_inst_wna1);
    U_AOI_3_3
	M181_inst_inst1_inst1 (m181_inst_wnor3_1, b3n, s3, a3n, a3n, s2, m181_inst_b3);
    U_AOI_1_2_2
	M181_inst_inst2_inst1 (m181_inst_wnor3_2, m181_inst_b3, s1, s0, b3n, a3n);
    U_AOI_3_3
	M181_inst_inst3_inst1 (m181_inst_wnor2_1, b2n, s3, a2n, a2n, s2, m181_inst_b2);
    U_AOI_1_2_2
	M181_inst_inst4_inst1 (m181_inst_wnor2_2, m181_inst_b2, s1, s0, b2n, a2n);
    U_AOI_3_3
	M181_inst_inst5_inst1 (m181_inst_wnor1_1, b1n, s3, a1n, a1n, s2, m181_inst_b1);
    U_AOI_1_2_2
	M181_inst_inst6_inst1 (m181_inst_wnor1_2, m181_inst_b1, s1, s0, b1n, a1n);
    U_AOI_3_3
	M181_inst_inst7_inst1 (m181_inst_wnor0_1, b0n, s3, a0n, a0n, s2, m181_inst_b0);
    U_AOI_1_2_2
	M181_inst_inst8_inst1 (m181_inst_wnor0_2, m181_inst_b0, s1, s0, b0n, a0n);
    U_AOI_2_3
	M181_inst_inst9_inst1 (m181_inst_wnor4, cn, m181_inst_m_, m181_inst_wnor0_1, m181_inst_wnor0_2, m181_inst_m_);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
